# 14 "ocamlbuild/lexers.mll"
 
exception Error of string
open Glob_ast

type conf_values =
  { plus_tags   : string list;
    minus_tags  : string list }

type conf = (Glob.globber * conf_values) list

let empty = { plus_tags = []; minus_tags = [] }

# 15 "ocamlbuild/lexers.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\253\255\254\255\001\000\255\255\002\000\007\000\008\000\
    \254\255\012\000\017\000\022\000\033\000\254\255\013\000\003\000\
    \038\000\043\000\018\000\004\000\054\000\059\000\252\255\064\000\
    \069\000\075\000\080\000\090\000\096\000\254\255\023\000\255\255\
    \027\000\086\000\252\255\253\255\102\000\104\000\108\000\255\255\
    \029\000\112\000\253\255\254\255\117\000\123\000\130\000\138\000\
    \145\000\151\000\252\255\253\255\156\000\160\000\164\000\255\255\
    \166\000\175\000\253\255\181\000\182\000\190\000\197\000\203\000\
    \208\000\025\000\253\255\039\000\046\000\061\000\253\255\254\255\
    \065\000\218\000\250\255\128\000\252\255\026\000\253\255\226\000\
    \035\001\212\000\232\000\233\000\075\001\254\255\047\000\255\255\
    \040\001\238\000\081\001\253\255\130\001\155\001\166\001\021\000\
    \202\001\212\001\092\000\218\001\253\001\255\255\012\002\254\255\
    \145\001\253\255\254\255\070\000\067\001\251\000\236\001\252\000\
    \255\001\018\002\001\001\007\002\100\000\251\255\087\000\106\000\
    \206\002\118\000\254\255\253\255\139\000\074\000\253\255\254\255\
    \192\000\255\255\068\001\254\255\048\000\088\001\124\001\054\000\
    \137\001\191\001\054\000\057\000\074\000\078\000\084\000\139\000\
    \207\001\027\001\053\001\013\001\100\000\088\000\106\000\097\000\
    \111\000\106\000\107\000\132\000\127\000\139\000\196\000\073\002\
    \045\001\122\001\058\001\154\000\152\000\156\000\167\000\164\000\
    \170\000\228\000\080\002\047\001\201\001\101\001\173\000\189\000\
    \188\000\192\000\180\000\206\000\016\001\203\000\032\001\019\001\
    \085\002\139\001\217\001\106\001\233\000\229\000\238\000\240\000\
    \241\000\243\000\246\000\051\001\106\002\005\002\013\002\173\001\
    \004\001\030\001\034\001\020\001\036\001\031\001\036\001\090\001\
    \114\002\035\002\036\002\044\002\119\002\124\002\130\002\140\002\
    \064\002\148\002\155\002\165\002\120\001\255\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\002\000\255\255\255\255\255\255\001\000\
    \255\255\000\000\002\000\255\255\255\255\255\255\002\000\002\000\
    \000\000\002\000\255\255\255\255\255\255\255\255\255\255\002\000\
    \002\000\004\000\004\000\255\255\255\255\255\255\000\000\255\255\
    \255\255\255\255\255\255\255\255\001\000\003\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\002\000\002\000\255\255\255\255\
    \000\000\255\255\255\255\255\255\001\000\003\000\255\255\255\255\
    \255\255\255\255\255\255\001\000\003\000\003\000\255\255\255\255\
    \000\000\000\000\255\255\001\000\000\000\255\255\255\255\255\255\
    \000\000\255\255\255\255\005\000\255\255\002\000\255\255\005\000\
    \005\000\004\000\255\255\255\255\255\255\255\255\000\000\255\255\
    \004\000\255\255\255\255\255\255\001\000\001\000\001\000\255\255\
    \255\255\000\000\255\255\255\255\000\000\255\255\001\000\255\255\
    \255\255\255\255\255\255\001\000\000\000\002\000\002\000\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\003\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \001\000\255\255\255\255\255\255\001\000\001\000\001\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\255\255\255\255";
  Lexing.lex_default = 
   "\003\000\000\000\000\000\005\000\000\000\005\000\009\000\255\255\
    \000\000\009\000\009\000\009\000\016\000\000\000\255\255\255\255\
    \016\000\016\000\255\255\255\255\016\000\023\000\000\000\023\000\
    \024\000\023\000\023\000\023\000\023\000\000\000\255\255\000\000\
    \032\000\036\000\000\000\000\000\036\000\036\000\036\000\000\000\
    \255\255\042\000\000\000\000\000\048\000\255\255\048\000\255\255\
    \048\000\052\000\000\000\000\000\052\000\052\000\052\000\000\000\
    \255\255\059\000\000\000\059\000\064\000\059\000\064\000\059\000\
    \064\000\068\000\000\000\067\000\068\000\070\000\000\000\000\000\
    \072\000\075\000\000\000\082\000\000\000\255\255\000\000\083\000\
    \082\000\255\255\082\000\083\000\082\000\000\000\255\255\000\000\
    \089\000\089\000\092\000\000\000\092\000\092\000\097\000\095\000\
    \102\000\097\000\098\000\100\000\100\000\000\000\102\000\000\000\
    \105\000\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\119\000\000\000\255\255\119\000\
    \255\255\121\000\000\000\000\000\255\255\127\000\000\000\000\000\
    \255\255\000\000\131\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \147\000\255\255\255\255\147\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\162\000\
    \255\255\255\255\162\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\173\000\255\255\255\255\173\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \187\000\255\255\255\255\187\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\199\000\255\255\255\255\199\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \211\000\255\255\255\255\211\000\213\000\213\000\213\000\213\000\
    \255\255\255\255\219\000\219\000\220\000\000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\255\255\255\255\001\000\255\255\255\255\
    \010\000\008\000\008\000\010\000\007\000\255\255\255\255\019\000\
    \255\255\255\255\011\000\008\000\019\000\011\000\007\000\011\000\
    \008\000\031\000\011\000\007\000\078\000\031\000\040\000\010\000\
    \030\000\040\000\017\000\015\000\255\255\017\000\014\000\255\255\
    \255\255\011\000\255\255\255\255\020\000\019\000\011\000\020\000\
    \018\000\087\000\001\000\004\000\004\000\040\000\103\000\020\000\
    \019\000\017\000\020\000\018\000\025\000\025\000\255\255\025\000\
    \026\000\255\255\255\255\020\000\255\255\255\255\032\000\031\000\
    \106\000\032\000\030\000\067\000\027\000\027\000\020\000\027\000\
    \028\000\027\000\027\000\025\000\027\000\028\000\024\000\037\000\
    \255\255\255\255\037\000\027\000\027\000\032\000\027\000\028\000\
    \255\255\027\000\027\000\027\000\027\000\028\000\024\000\040\000\
    \027\000\038\000\040\000\024\000\038\000\038\000\037\000\072\000\
    \038\000\045\000\027\000\255\255\045\000\024\000\046\000\120\000\
    \027\000\046\000\034\000\024\000\047\000\101\000\040\000\047\000\
    \038\000\118\000\255\255\046\000\038\000\255\255\046\000\255\255\
    \045\000\138\000\255\255\047\000\255\255\046\000\047\000\138\000\
    \255\255\139\000\255\255\047\000\044\000\255\255\255\255\123\000\
    \053\000\255\255\046\000\053\000\140\000\056\000\128\000\046\000\
    \056\000\054\000\047\000\141\000\054\000\054\000\255\255\056\000\
    \054\000\255\255\056\000\121\000\121\000\142\000\046\000\053\000\
    \061\000\143\000\081\000\061\000\056\000\255\255\255\255\062\000\
    \054\000\255\255\062\000\050\000\054\000\144\000\056\000\063\000\
    \255\255\149\000\063\000\150\000\255\255\151\000\062\000\061\000\
    \255\255\062\000\124\000\152\000\063\000\255\255\062\000\063\000\
    \153\000\255\255\154\000\060\000\255\255\081\000\063\000\155\000\
    \081\000\255\255\255\255\080\000\078\000\062\000\080\000\077\000\
    \129\000\129\000\062\000\063\000\087\000\156\000\157\000\086\000\
    \255\255\255\255\255\255\087\000\081\000\255\255\086\000\062\000\
    \087\000\158\000\080\000\086\000\255\255\079\000\159\000\164\000\
    \002\000\255\255\255\255\013\000\013\000\112\000\112\000\255\255\
    \113\000\113\000\165\000\108\000\255\255\013\000\115\000\166\000\
    \167\000\255\255\013\000\168\000\074\000\255\255\255\255\146\000\
    \169\000\066\000\145\000\029\000\088\000\039\000\170\000\175\000\
    \176\000\013\000\081\000\088\000\177\000\146\000\255\255\255\255\
    \145\000\178\000\179\000\013\000\084\000\078\000\255\255\084\000\
    \077\000\088\000\087\000\180\000\088\000\086\000\013\000\161\000\
    \181\000\172\000\160\000\022\000\171\000\071\000\182\000\146\000\
    \255\255\255\255\145\000\084\000\161\000\029\000\083\000\160\000\
    \088\000\183\000\126\000\022\000\108\000\184\000\134\000\108\000\
    \022\000\133\000\189\000\190\000\084\000\078\000\035\000\084\000\
    \077\000\191\000\022\000\091\000\255\255\081\000\091\000\192\000\
    \022\000\193\000\137\000\108\000\117\000\136\000\039\000\194\000\
    \035\000\195\000\255\255\084\000\035\000\196\000\083\000\172\000\
    \043\000\091\000\171\000\201\000\186\000\255\255\255\255\185\000\
    \091\000\091\000\091\000\043\000\093\000\091\000\094\000\148\000\
    \255\255\202\000\255\255\203\000\161\000\081\000\137\000\160\000\
    \204\000\136\000\043\000\091\000\255\255\205\000\206\000\255\255\
    \174\000\255\255\207\000\137\000\208\000\186\000\136\000\051\000\
    \185\000\148\000\110\000\106\000\055\000\110\000\107\000\114\000\
    \051\000\221\000\255\255\163\000\051\000\255\255\055\000\000\000\
    \255\255\255\255\095\000\255\255\000\000\000\000\255\255\058\000\
    \255\255\110\000\000\000\255\255\132\000\255\255\255\255\198\000\
    \000\000\000\000\197\000\255\255\096\000\108\000\058\000\000\000\
    \000\000\000\000\255\255\095\000\255\255\255\255\255\255\255\255\
    \135\000\137\000\000\000\058\000\136\000\255\255\095\000\255\255\
    \255\255\000\000\255\255\172\000\255\255\096\000\171\000\255\255\
    \144\000\146\000\076\000\144\000\145\000\000\000\255\255\000\000\
    \096\000\255\255\085\000\186\000\255\255\000\000\185\000\255\255\
    \255\255\085\000\255\255\000\000\135\000\109\000\085\000\144\000\
    \163\000\255\255\255\255\255\255\255\255\112\000\255\255\188\000\
    \112\000\135\000\255\255\255\255\098\000\255\255\000\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\000\000\255\255\255\255\
    \112\000\000\000\255\255\112\000\112\000\255\255\099\000\198\000\
    \108\000\108\000\197\000\108\000\255\255\000\000\255\255\198\000\
    \108\000\255\255\197\000\112\000\112\000\255\255\112\000\112\000\
    \000\000\000\000\000\000\076\000\255\255\255\255\255\255\108\000\
    \085\000\255\255\174\000\108\000\255\255\210\000\210\000\135\000\
    \209\000\209\000\112\000\255\255\255\255\255\255\210\000\255\255\
    \255\255\209\000\255\255\000\000\000\000\000\000\108\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\188\000\255\255\000\000\
    \111\000\216\000\216\000\076\000\216\000\217\000\000\000\000\000\
    \000\000\091\000\159\000\161\000\000\000\159\000\160\000\000\000\
    \000\000\170\000\172\000\111\000\170\000\171\000\184\000\186\000\
    \216\000\184\000\185\000\114\000\000\000\255\255\000\000\000\000\
    \000\000\159\000\255\255\000\000\000\000\000\000\111\000\000\000\
    \170\000\200\000\000\000\196\000\198\000\184\000\196\000\197\000\
    \255\255\200\000\000\000\208\000\210\000\000\000\208\000\209\000\
    \214\000\214\000\255\255\214\000\215\000\216\000\216\000\000\000\
    \216\000\217\000\196\000\214\000\214\000\000\000\214\000\215\000\
    \000\000\106\000\208\000\000\000\000\000\214\000\214\000\214\000\
    \214\000\215\000\000\000\255\255\216\000\216\000\216\000\000\000\
    \216\000\217\000\214\000\000\000\000\000\255\255\255\255\000\000\
    \255\255\000\000\000\000\000\000\214\000\255\255\000\000\255\255\
    \000\000\000\000\255\255\000\000\216\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\255\255\255\255\255\255\000\000\255\255\
    \000\000\000\000\255\255\000\000\255\255\220\000\255\255\255\255\
    \000\000\255\255\000\000\000\000\255\255\255\255\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\122\000\
    \000\000\000\000\000\000\120\000\000\000\255\255\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \121\000\000\000\000\000\000\000\255\255\000\000\000\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\000\000\000\000\000\000\255\255\120\000\000\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\003\000\005\000\000\000\003\000\005\000\
    \006\000\006\000\007\000\006\000\006\000\009\000\009\000\014\000\
    \009\000\009\000\010\000\010\000\018\000\010\000\010\000\011\000\
    \011\000\030\000\011\000\011\000\077\000\032\000\040\000\006\000\
    \032\000\040\000\012\000\012\000\009\000\012\000\012\000\016\000\
    \016\000\010\000\016\000\016\000\017\000\017\000\011\000\017\000\
    \017\000\086\000\000\000\003\000\005\000\040\000\095\000\020\000\
    \020\000\012\000\020\000\020\000\021\000\021\000\016\000\021\000\
    \021\000\023\000\023\000\017\000\023\000\023\000\024\000\024\000\
    \107\000\024\000\024\000\065\000\025\000\025\000\020\000\025\000\
    \025\000\026\000\026\000\021\000\026\000\026\000\021\000\033\000\
    \023\000\067\000\033\000\027\000\027\000\024\000\027\000\027\000\
    \068\000\028\000\028\000\025\000\028\000\028\000\025\000\036\000\
    \026\000\037\000\036\000\026\000\037\000\038\000\033\000\069\000\
    \038\000\041\000\027\000\072\000\041\000\027\000\044\000\118\000\
    \028\000\044\000\033\000\028\000\045\000\098\000\036\000\045\000\
    \037\000\116\000\075\000\046\000\038\000\075\000\046\000\119\000\
    \041\000\132\000\036\000\047\000\037\000\044\000\047\000\135\000\
    \038\000\138\000\048\000\045\000\041\000\048\000\121\000\121\000\
    \049\000\044\000\046\000\049\000\139\000\052\000\125\000\045\000\
    \052\000\053\000\047\000\140\000\053\000\054\000\046\000\056\000\
    \054\000\048\000\056\000\124\000\124\000\141\000\047\000\049\000\
    \057\000\142\000\075\000\057\000\052\000\048\000\059\000\060\000\
    \053\000\059\000\060\000\049\000\054\000\143\000\056\000\061\000\
    \052\000\148\000\061\000\149\000\053\000\150\000\062\000\057\000\
    \054\000\062\000\121\000\151\000\063\000\059\000\060\000\063\000\
    \152\000\064\000\153\000\057\000\064\000\081\000\061\000\154\000\
    \081\000\059\000\060\000\073\000\073\000\062\000\073\000\073\000\
    \128\000\128\000\061\000\063\000\079\000\155\000\156\000\079\000\
    \064\000\062\000\082\000\083\000\081\000\082\000\083\000\063\000\
    \089\000\157\000\073\000\089\000\064\000\073\000\158\000\163\000\
    \000\000\003\000\005\000\015\000\019\000\109\000\111\000\006\000\
    \109\000\111\000\164\000\114\000\009\000\014\000\114\000\165\000\
    \166\000\010\000\018\000\167\000\073\000\095\000\011\000\147\000\
    \168\000\065\000\147\000\032\000\079\000\040\000\169\000\174\000\
    \175\000\012\000\082\000\083\000\176\000\145\000\016\000\067\000\
    \145\000\177\000\178\000\017\000\080\000\080\000\068\000\080\000\
    \080\000\088\000\088\000\179\000\088\000\088\000\020\000\160\000\
    \180\000\171\000\160\000\021\000\171\000\069\000\181\000\146\000\
    \023\000\072\000\146\000\080\000\162\000\024\000\080\000\162\000\
    \088\000\182\000\125\000\025\000\108\000\183\000\130\000\108\000\
    \026\000\130\000\188\000\189\000\084\000\084\000\033\000\084\000\
    \084\000\190\000\027\000\090\000\098\000\080\000\090\000\191\000\
    \028\000\192\000\133\000\108\000\116\000\133\000\036\000\193\000\
    \037\000\194\000\119\000\084\000\038\000\195\000\084\000\173\000\
    \041\000\090\000\173\000\200\000\187\000\044\000\121\000\187\000\
    \090\000\090\000\090\000\045\000\090\000\090\000\090\000\145\000\
    \075\000\201\000\046\000\202\000\161\000\084\000\134\000\161\000\
    \203\000\134\000\047\000\090\000\092\000\204\000\205\000\092\000\
    \171\000\048\000\206\000\136\000\207\000\185\000\136\000\049\000\
    \185\000\146\000\104\000\104\000\052\000\104\000\104\000\108\000\
    \053\000\220\000\092\000\160\000\054\000\093\000\056\000\255\255\
    \093\000\092\000\092\000\092\000\255\255\255\255\092\000\057\000\
    \094\000\104\000\255\255\094\000\130\000\059\000\060\000\199\000\
    \255\255\255\255\199\000\093\000\092\000\104\000\061\000\255\255\
    \255\255\255\255\093\000\093\000\093\000\062\000\094\000\093\000\
    \133\000\137\000\255\255\063\000\137\000\094\000\094\000\094\000\
    \064\000\255\255\094\000\172\000\096\000\093\000\172\000\096\000\
    \144\000\144\000\073\000\144\000\144\000\255\255\097\000\255\255\
    \094\000\097\000\079\000\186\000\099\000\255\255\186\000\099\000\
    \082\000\083\000\096\000\255\255\134\000\104\000\089\000\144\000\
    \161\000\096\000\096\000\096\000\097\000\110\000\096\000\185\000\
    \110\000\136\000\099\000\097\000\097\000\097\000\255\255\255\255\
    \097\000\099\000\099\000\099\000\096\000\255\255\099\000\100\000\
    \112\000\255\255\100\000\112\000\110\000\147\000\097\000\197\000\
    \115\000\115\000\197\000\115\000\099\000\255\255\102\000\198\000\
    \110\000\102\000\198\000\113\000\113\000\100\000\113\000\112\000\
    \255\255\255\255\255\255\080\000\100\000\100\000\100\000\115\000\
    \088\000\100\000\172\000\112\000\102\000\209\000\210\000\137\000\
    \209\000\210\000\113\000\102\000\102\000\102\000\211\000\100\000\
    \102\000\211\000\162\000\255\255\255\255\255\255\113\000\255\255\
    \255\255\255\255\255\255\255\255\130\000\186\000\102\000\255\255\
    \110\000\216\000\216\000\084\000\216\000\216\000\255\255\255\255\
    \255\255\090\000\159\000\159\000\255\255\159\000\159\000\255\255\
    \255\255\170\000\170\000\112\000\170\000\170\000\184\000\184\000\
    \216\000\184\000\184\000\115\000\255\255\173\000\255\255\255\255\
    \255\255\159\000\187\000\255\255\255\255\255\255\113\000\255\255\
    \170\000\197\000\255\255\196\000\196\000\184\000\196\000\196\000\
    \220\000\198\000\255\255\208\000\208\000\255\255\208\000\208\000\
    \212\000\212\000\092\000\212\000\212\000\213\000\213\000\255\255\
    \213\000\213\000\196\000\214\000\214\000\255\255\214\000\214\000\
    \255\255\104\000\208\000\255\255\255\255\215\000\215\000\212\000\
    \215\000\215\000\255\255\093\000\213\000\217\000\217\000\255\255\
    \217\000\217\000\214\000\255\255\255\255\218\000\094\000\255\255\
    \218\000\255\255\255\255\255\255\215\000\199\000\255\255\219\000\
    \255\255\255\255\219\000\255\255\217\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\218\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\218\000\218\000\218\000\219\000\255\255\218\000\
    \255\255\255\255\096\000\255\255\219\000\219\000\219\000\144\000\
    \255\255\219\000\255\255\255\255\097\000\218\000\255\255\255\255\
    \255\255\255\255\099\000\255\255\255\255\255\255\255\255\219\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\120\000\
    \255\255\255\255\255\255\120\000\255\255\100\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\255\255\255\255\255\255\102\000\255\255\255\255\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\255\255\255\255\255\255\211\000\120\000\255\255\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\159\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \170\000\255\255\255\255\255\255\255\255\184\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\196\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\208\000\255\255\255\255\255\255\255\255\212\000\
    \255\255\255\255\255\255\255\255\213\000\255\255\255\255\255\255\
    \255\255\255\255\214\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\215\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\218\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\219\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\002\000\006\000\000\000\000\000\000\000\
    \000\000\007\000\000\000\000\000\008\000\012\000\000\000\000\000\
    \000\000\017\000\033\000\038\000\043\000\000\000\000\000\000\000\
    \000\000\045\000\000\000\000\000\049\000\050\000\051\000\018\000\
    \000\000\020\000\000\000\000\000\059\000\022\000\060\000\023\000\
    \000\000\064\000\000\000\000\000\075\000\088\000\089\000\018\000\
    \000\000\090\000\000\000\000\000\094\000\103\000\104\000\105\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\118\000\000\000\128\000\000\000\000\000\000\000\129\000\
    \142\000\000\000\130\000\135\000\147\000\000\000\000\000\000\000\
    \000\000\000\000\031\000\000\000\000\000\151\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\
    \162\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\
    \153\000\000\000\000\000\157\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\021\000\189\000\
    \000\000\000\000\158\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\022\000\020\001\000\000\000\000\159\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\027\000\
    \025\001\000\000\000\000\165\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\028\000\030\001\000\000\000\000\167\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\
    \046\001\000\000\000\000\171\000\058\001\064\001\070\001\082\001\
    \000\000\000\000\136\001\142\001\063\000\208\000";
  Lexing.lex_backtrk_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \004\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\
    \004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \004\000\000\000\000\000\000\000\015\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\
    \026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\045\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \060\000\000\000\000\000\000\000\004\000\004\000\004\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\146\000\146\000\000\000\171\000\171\000\171\000\181\000\
    \171\000\171\000\000\000\200\000\000\000\000\000";
  Lexing.lex_default_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\007\000\000\000\000\000\007\000\007\000\007\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\007\000\000\000\000\000\007\000\007\000\007\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\029\000\000\000\037\000\000\000\000\000\000\000\037\000\
    \029\000\000\000\029\000\029\000\037\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\065\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \073\000\000\000\000\000\073\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\086\000\
    \000\000\000\000\086\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\099\000\000\000\000\000\099\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \112\000\000\000\000\000\112\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\125\000\000\000\000\000\125\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \138\000\000\000\000\000\138\000\023\000\023\000\023\000\186\000\
    \000\000\000\000\029\000\029\000\205\000\000\000";
  Lexing.lex_trans_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\000\000\
    \001\000\001\000\001\000\001\000\000\000\001\000\001\000\000\000\
    \001\000\001\000\001\000\000\000\000\000\000\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\010\000\001\000\
    \001\000\010\000\000\000\010\000\010\000\000\000\010\000\010\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\010\000\023\000\001\000\010\000\010\000\068\000\081\000\
    \094\000\000\000\010\000\010\000\000\000\107\000\120\000\000\000\
    \133\000\000\000\000\000\001\000\001\000\000\000\000\000\000\000\
    \010\000\010\000\010\000\001\000\010\000\010\000\001\000\023\000\
    \000\000\000\000\023\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\023\000\001\000\001\000\023\000\001\000\000\000\000\000\
    \010\000\010\000\001\000\000\000\000\000\000\000\023\000\032\000\
    \000\000\000\000\032\000\000\000\000\000\000\000\023\000\001\000\
    \023\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\023\000\000\000\023\000\032\000\010\000\
    \000\000\000\000\010\000\000\000\053\000\000\000\000\000\053\000\
    \000\000\000\000\076\000\000\000\000\000\076\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\010\000\000\000\
    \000\000\000\000\000\000\053\000\000\000\000\000\000\000\000\000\
    \000\000\076\000\000\000\042\000\050\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\089\000\000\000\
    \000\000\089\000\000\000\000\000\000\000\050\000\000\000\001\000\
    \000\000\000\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\000\000\089\000\000\000\000\000\
    \000\000\000\000\000\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\000\000\000\000\000\000\
    \000\000\001\000\000\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\001\000\102\000\000\000\000\000\
    \102\000\000\000\115\000\000\000\000\000\115\000\000\000\128\000\
    \000\000\000\000\128\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\102\000\000\000\000\000\141\000\
    \000\000\115\000\141\000\000\000\000\000\000\000\128\000\000\000\
    \000\000\000\000\000\000\010\000\010\000\000\000\010\000\176\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\141\000\010\000\
    \010\000\000\000\010\000\176\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\010\000\010\000\010\000\000\000\010\000\191\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\010\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\010\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\176\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check_code = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\006\000\010\000\011\000\006\000\010\000\011\000\012\000\
    \017\000\020\000\012\000\017\000\020\000\021\000\021\000\255\255\
    \021\000\021\000\025\000\025\000\255\255\025\000\025\000\255\255\
    \006\000\010\000\011\000\255\255\255\255\255\255\012\000\017\000\
    \020\000\118\000\026\000\026\000\021\000\026\000\026\000\027\000\
    \027\000\025\000\027\000\027\000\028\000\028\000\033\000\028\000\
    \028\000\033\000\036\000\037\000\038\000\036\000\037\000\038\000\
    \041\000\026\000\045\000\047\000\044\000\046\000\027\000\044\000\
    \046\000\049\000\090\000\028\000\049\000\033\000\143\000\158\000\
    \169\000\036\000\037\000\038\000\052\000\183\000\195\000\052\000\
    \207\000\033\000\255\255\044\000\046\000\036\000\037\000\038\000\
    \049\000\053\000\054\000\057\000\053\000\054\000\057\000\060\000\
    \220\000\255\255\060\000\052\000\049\000\255\255\255\255\255\255\
    \061\000\062\000\063\000\061\000\062\000\063\000\255\255\052\000\
    \053\000\054\000\057\000\255\255\255\255\255\255\060\000\073\000\
    \073\000\255\255\073\000\073\000\053\000\054\000\057\000\061\000\
    \062\000\063\000\075\000\079\000\082\000\075\000\079\000\082\000\
    \255\255\083\000\255\255\061\000\083\000\063\000\073\000\080\000\
    \080\000\255\255\080\000\080\000\084\000\084\000\255\255\084\000\
    \084\000\093\000\144\000\144\000\093\000\144\000\144\000\147\000\
    \162\000\173\000\147\000\162\000\173\000\255\255\080\000\187\000\
    \073\000\199\000\187\000\084\000\199\000\211\000\255\255\093\000\
    \211\000\144\000\075\000\079\000\082\000\255\255\093\000\093\000\
    \093\000\083\000\255\255\093\000\255\255\255\255\159\000\159\000\
    \080\000\159\000\159\000\255\255\255\255\084\000\255\255\120\000\
    \255\255\093\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\255\255\159\000\255\255\255\255\
    \255\255\255\255\255\255\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\255\255\255\255\255\255\
    \255\255\120\000\255\255\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\170\000\170\000\255\255\
    \170\000\170\000\184\000\184\000\255\255\184\000\184\000\196\000\
    \196\000\255\255\196\000\196\000\255\255\033\000\255\255\255\255\
    \255\255\036\000\037\000\038\000\170\000\255\255\255\255\208\000\
    \208\000\184\000\208\000\208\000\255\255\255\255\196\000\220\000\
    \049\000\255\255\255\255\212\000\212\000\255\255\212\000\212\000\
    \255\255\213\000\213\000\052\000\213\000\213\000\208\000\214\000\
    \214\000\255\255\214\000\214\000\255\255\255\255\255\255\255\255\
    \053\000\054\000\212\000\215\000\215\000\255\255\215\000\215\000\
    \213\000\255\255\255\255\255\255\255\255\255\255\214\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\215\000\255\255\255\255\255\255\073\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \075\000\079\000\082\000\255\255\255\255\255\255\255\255\083\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\080\000\255\255\
    \255\255\255\255\218\000\084\000\255\255\218\000\255\255\093\000\
    \219\000\144\000\255\255\219\000\255\255\147\000\162\000\173\000\
    \255\255\255\255\255\255\255\255\255\255\187\000\255\255\199\000\
    \218\000\255\255\255\255\211\000\255\255\255\255\219\000\218\000\
    \218\000\218\000\255\255\255\255\218\000\219\000\219\000\219\000\
    \255\255\255\255\219\000\255\255\255\255\159\000\255\255\255\255\
    \255\255\255\255\218\000\255\255\255\255\255\255\255\255\255\255\
    \219\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\170\000\255\255\255\255\255\255\
    \255\255\184\000\255\255\255\255\255\255\255\255\196\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\208\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\212\000\255\255\255\255\255\255\255\255\255\255\
    \213\000\255\255\255\255\255\255\255\255\255\255\214\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\215\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \218\000\255\255\255\255\255\255\255\255\255\255\219\000";
  Lexing.lex_code = 
   "\255\001\255\255\000\001\255\004\255\255\003\255\002\255\255\000\
    \003\255\000\002\001\004\255\002\255\255\000\002\255\003\255\255\
    \004\255\003\255\255\004\002\003\255\255\004\002\255\000\002\001\
    \003\255\002\004\255\004\002\002\255\003\255\255\000\004\001\003\
    \255\001\002\255\013\255\012\255\255\013\255\255\012\255\013\255\
    \255\015\255\014\255\255\015\255\255\014\255\015\255\255\017\255\
    \016\255\255\017\255\255\016\255\017\255\255\019\255\018\255\255\
    \019\255\255\018\255\019\255\255\021\255\020\255\255\021\255\255\
    \020\255\021\255\255\023\255\022\255\255\023\255\255\022\255\023\
    \255\255\004\016\005\017\000\012\001\013\008\020\009\021\010\022\
    \011\023\002\014\003\015\006\018\007\019\255\000\003\001\002\255\
    \005\255\004\255\255\000\005\001\004\255\003\005\002\255\255\003\
    \005\002\004\005\255\004\255\255\002\255\000\003\255\005\255\255\
    \002\004\001\005\000\003\255";
}

let rec ocamldep_output lexbuf =
    __ocaml_lex_ocamldep_output_rec lexbuf 0
and __ocaml_lex_ocamldep_output_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 42 "ocamlbuild/lexers.mll"
                            k
# 628 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos (lexbuf.Lexing.lex_curr_pos + -1) in
# 42 "ocamlbuild/lexers.mll"
                                   ( let x = (k, space_sep_strings_nl lexbuf) in x :: ocamldep_output lexbuf )
# 632 "ocamlbuild/lexers.ml"

  | 1 ->
# 43 "ocamlbuild/lexers.mll"
        ( [] )
# 637 "ocamlbuild/lexers.ml"

  | 2 ->
# 44 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting colon followed by space-separated module name list") )
# 642 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_ocamldep_output_rec lexbuf __ocaml_lex_state

and space_sep_strings_nl lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ; (* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_space_sep_strings_nl_rec lexbuf 6
and __ocaml_lex_space_sep_strings_nl_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 47 "ocamlbuild/lexers.mll"
                          word
# 656 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 47 "ocamlbuild/lexers.mll"
                                ( word :: space_sep_strings_nl lexbuf )
# 660 "ocamlbuild/lexers.ml"

  | 1 ->
# 48 "ocamlbuild/lexers.mll"
                   ( [] )
# 665 "ocamlbuild/lexers.ml"

  | 2 ->
# 49 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting space-separated strings terminated with newline") )
# 670 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_space_sep_strings_nl_rec lexbuf __ocaml_lex_state

and space_sep_strings lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ; (* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_space_sep_strings_rec lexbuf 12
and __ocaml_lex_space_sep_strings_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 52 "ocamlbuild/lexers.mll"
                          word
# 684 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 52 "ocamlbuild/lexers.mll"
                                ( word :: space_sep_strings lexbuf )
# 688 "ocamlbuild/lexers.ml"

  | 1 ->
# 53 "ocamlbuild/lexers.mll"
                        ( [] )
# 693 "ocamlbuild/lexers.ml"

  | 2 ->
# 54 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting space-separated strings") )
# 698 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_space_sep_strings_rec lexbuf __ocaml_lex_state

and blank_sep_strings lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ; (* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_blank_sep_strings_rec lexbuf 21
and __ocaml_lex_blank_sep_strings_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 57 "ocamlbuild/lexers.mll"
                                    ( blank_sep_strings lexbuf )
# 711 "ocamlbuild/lexers.ml"

  | 1 ->
# 58 "ocamlbuild/lexers.mll"
                                ( [] )
# 716 "ocamlbuild/lexers.ml"

  | 2 ->
let
# 59 "ocamlbuild/lexers.mll"
                          word
# 722 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 59 "ocamlbuild/lexers.mll"
                                ( word :: blank_sep_strings lexbuf )
# 726 "ocamlbuild/lexers.ml"

  | 3 ->
# 60 "ocamlbuild/lexers.mll"
               ( [] )
# 731 "ocamlbuild/lexers.ml"

  | 4 ->
# 61 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting blank-separated strings") )
# 736 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_blank_sep_strings_rec lexbuf __ocaml_lex_state

and comma_sep_strings lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 5 (-1) ; (* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_comma_sep_strings_rec lexbuf 33
and __ocaml_lex_comma_sep_strings_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 64 "ocamlbuild/lexers.mll"
                                    word
# 751 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 64 "ocamlbuild/lexers.mll"
                                                     ( [word] )
# 755 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 65 "ocamlbuild/lexers.mll"
                                    word
# 761 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 65 "ocamlbuild/lexers.mll"
                                          ( word :: comma_sep_strings_aux lexbuf )
# 765 "ocamlbuild/lexers.ml"

  | 2 ->
# 66 "ocamlbuild/lexers.mll"
               ( [] )
# 770 "ocamlbuild/lexers.ml"

  | 3 ->
# 67 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting comma-separated strings (1)") )
# 775 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comma_sep_strings_rec lexbuf __ocaml_lex_state

and comma_sep_strings_aux lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ;   __ocaml_lex_comma_sep_strings_aux_rec lexbuf 41
and __ocaml_lex_comma_sep_strings_aux_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 69 "ocamlbuild/lexers.mll"
                                               word
# 787 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 69 "ocamlbuild/lexers.mll"
                                                     ( word :: comma_sep_strings_aux lexbuf )
# 791 "ocamlbuild/lexers.ml"

  | 1 ->
# 70 "ocamlbuild/lexers.mll"
               ( [] )
# 796 "ocamlbuild/lexers.ml"

  | 2 ->
# 71 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting comma-separated strings (2)") )
# 801 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comma_sep_strings_aux_rec lexbuf __ocaml_lex_state

and comma_or_blank_sep_strings lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 5 (-1) ; (* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_comma_or_blank_sep_strings_rec lexbuf 49
and __ocaml_lex_comma_or_blank_sep_strings_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 74 "ocamlbuild/lexers.mll"
                                    word
# 816 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 74 "ocamlbuild/lexers.mll"
                                                     ( [word] )
# 820 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 75 "ocamlbuild/lexers.mll"
                                    word
# 826 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 75 "ocamlbuild/lexers.mll"
                                          ( word :: comma_or_blank_sep_strings_aux lexbuf )
# 830 "ocamlbuild/lexers.ml"

  | 2 ->
# 76 "ocamlbuild/lexers.mll"
               ( [] )
# 835 "ocamlbuild/lexers.ml"

  | 3 ->
# 77 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting (comma|blank)-separated strings (1)") )
# 840 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comma_or_blank_sep_strings_rec lexbuf __ocaml_lex_state

and comma_or_blank_sep_strings_aux lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 3 (-1) ; (* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_comma_or_blank_sep_strings_aux_rec lexbuf 57
and __ocaml_lex_comma_or_blank_sep_strings_aux_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 79 "ocamlbuild/lexers.mll"
                                               word
# 854 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 79 "ocamlbuild/lexers.mll"
                                                     ( word :: comma_or_blank_sep_strings_aux lexbuf )
# 858 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 80 "ocamlbuild/lexers.mll"
                                    word
# 864 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 80 "ocamlbuild/lexers.mll"
                                          ( word :: comma_or_blank_sep_strings_aux lexbuf )
# 868 "ocamlbuild/lexers.ml"

  | 2 ->
# 81 "ocamlbuild/lexers.mll"
               ( [] )
# 873 "ocamlbuild/lexers.ml"

  | 3 ->
# 82 "ocamlbuild/lexers.mll"
      ( raise (Error "Expecting (comma|blank)-separated strings (2)") )
# 878 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comma_or_blank_sep_strings_aux_rec lexbuf __ocaml_lex_state

and parse_environment_path lexbuf =
    __ocaml_lex_parse_environment_path_rec lexbuf 65
and __ocaml_lex_parse_environment_path_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 85 "ocamlbuild/lexers.mll"
                 word
# 890 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 85 "ocamlbuild/lexers.mll"
                       ( word :: parse_environment_path_aux lexbuf )
# 894 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 86 "ocamlbuild/lexers.mll"
                     word
# 900 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 86 "ocamlbuild/lexers.mll"
                           ( "" :: word :: parse_environment_path_aux lexbuf )
# 904 "ocamlbuild/lexers.ml"

  | 2 ->
# 87 "ocamlbuild/lexers.mll"
        ( [] )
# 909 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_parse_environment_path_rec lexbuf __ocaml_lex_state

and parse_environment_path_aux lexbuf =
    __ocaml_lex_parse_environment_path_aux_rec lexbuf 69
and __ocaml_lex_parse_environment_path_aux_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 89 "ocamlbuild/lexers.mll"
                     word
# 921 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 89 "ocamlbuild/lexers.mll"
                           ( word :: parse_environment_path_aux lexbuf )
# 925 "ocamlbuild/lexers.ml"

  | 1 ->
# 90 "ocamlbuild/lexers.mll"
        ( [] )
# 930 "ocamlbuild/lexers.ml"

  | 2 ->
# 91 "ocamlbuild/lexers.mll"
      ( raise (Error "Impossible: expecting colon-separated strings") )
# 935 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_parse_environment_path_aux_rec lexbuf __ocaml_lex_state

and conf_lines dir pos err lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 5 (-1) ; (* L=1 [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_conf_lines_rec dir pos err lexbuf 73
and __ocaml_lex_conf_lines_rec dir pos err lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 94 "ocamlbuild/lexers.mll"
                                    ( conf_lines dir (pos + 1) err lexbuf )
# 948 "ocamlbuild/lexers.ml"

  | 1 ->
# 95 "ocamlbuild/lexers.mll"
                                ( [] )
# 953 "ocamlbuild/lexers.ml"

  | 2 ->
# 96 "ocamlbuild/lexers.mll"
                   ( conf_lines dir (pos + 1) err lexbuf )
# 958 "ocamlbuild/lexers.ml"

  | 3 ->
# 97 "ocamlbuild/lexers.mll"
               ( [] )
# 963 "ocamlbuild/lexers.ml"

  | 4 ->
let
# 98 "ocamlbuild/lexers.mll"
                                      k
# 969 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 99 "ocamlbuild/lexers.mll"
      (
        let bexpr = Glob.parse ?dir k in
        let v1 = conf_value pos err empty lexbuf in
        let v2 = conf_values pos err v1 lexbuf in
        let rest = conf_lines dir (pos + 1) err lexbuf in (bexpr, v2) :: rest
      )
# 978 "ocamlbuild/lexers.ml"

  | 5 ->
# 105 "ocamlbuild/lexers.mll"
      ( raise (Error(Printf.sprintf "Bad key in configuration line at line %d (from %s)" pos err)) )
# 983 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_conf_lines_rec dir pos err lexbuf __ocaml_lex_state

and conf_value pos err x lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 3 (-1) ; (* L=1 [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_conf_value_rec pos err x lexbuf 90
and __ocaml_lex_conf_value_rec pos err x lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 108 "ocamlbuild/lexers.mll"
                 tag
# 997 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 108 "ocamlbuild/lexers.mll"
                      ( { (x) with minus_tags = tag :: x.minus_tags } )
# 1001 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 109 "ocamlbuild/lexers.mll"
                 tag
# 1007 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_curr_pos in
# 109 "ocamlbuild/lexers.mll"
                      ( { (x) with plus_tags = tag :: x.plus_tags } )
# 1011 "ocamlbuild/lexers.ml"

  | 2 ->
# 110 "ocamlbuild/lexers.mll"
              ( raise (Error(Printf.sprintf "Bad value in configuration line at line %d (from %s)" pos err)) )
# 1016 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_conf_value_rec pos err x lexbuf __ocaml_lex_state

and conf_values pos err x lexbuf =
    __ocaml_lex_conf_values_rec pos err x lexbuf 104
and __ocaml_lex_conf_values_rec pos err x lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 113 "ocamlbuild/lexers.mll"
                                          ( conf_values pos err (conf_value pos err x lexbuf) lexbuf )
# 1027 "ocamlbuild/lexers.ml"

  | 1 ->
# 114 "ocamlbuild/lexers.mll"
                    ( x )
# 1032 "ocamlbuild/lexers.ml"

  | 2 ->
# 115 "ocamlbuild/lexers.mll"
              ( raise (Error(Printf.sprintf "Bad values in configuration line at line %d (from %s)" pos err)) )
# 1037 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_conf_values_rec pos err x lexbuf __ocaml_lex_state

and path_scheme patt_allowed lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ;   __ocaml_lex_path_scheme_rec patt_allowed lexbuf 116
and __ocaml_lex_path_scheme_rec patt_allowed lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 118 "ocamlbuild/lexers.mll"
                  prefix
# 1049 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 119 "ocamlbuild/lexers.mll"
      ( `Word prefix :: path_scheme patt_allowed lexbuf )
# 1053 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 120 "ocamlbuild/lexers.mll"
                      var
# 1059 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) (lexbuf.Lexing.lex_curr_pos + -1) in
# 121 "ocamlbuild/lexers.mll"
      ( `Var (var, Bool.True) :: path_scheme patt_allowed lexbuf )
# 1063 "ocamlbuild/lexers.ml"

  | 2 ->
let
# 122 "ocamlbuild/lexers.mll"
                      var
# 1069 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_mem.(0)
and
# 122 "ocamlbuild/lexers.mll"
                                           patt
# 1074 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 123 "ocamlbuild/lexers.mll"
      ( if patt_allowed then
          let patt = My_std.String.implode (unescape (Lexing.from_string patt)) in
          `Var (var, Glob.parse patt) :: path_scheme patt_allowed lexbuf
        else raise (Error(
          Printf.sprintf "Patterns are not allowed in this pathname (%%(%s:%s) only in ~prod)"
            var patt)) )
# 1083 "ocamlbuild/lexers.ml"

  | 3 ->
# 130 "ocamlbuild/lexers.mll"
      ( `Var ("", Bool.True) :: path_scheme patt_allowed lexbuf )
# 1088 "ocamlbuild/lexers.ml"

  | 4 ->
# 132 "ocamlbuild/lexers.mll"
      ( [] )
# 1093 "ocamlbuild/lexers.ml"

  | 5 ->
# 133 "ocamlbuild/lexers.mll"
      ( raise (Error("Bad pathanme scheme")) )
# 1098 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_path_scheme_rec patt_allowed lexbuf __ocaml_lex_state

and unescape lexbuf =
    __ocaml_lex_unescape_rec lexbuf 125
and __ocaml_lex_unescape_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 136 "ocamlbuild/lexers.mll"
                       c
# 1110 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 136 "ocamlbuild/lexers.mll"
                                 ( c :: unescape lexbuf )
# 1114 "ocamlbuild/lexers.ml"

  | 1 ->
let
# 137 "ocamlbuild/lexers.mll"
         c
# 1120 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 137 "ocamlbuild/lexers.mll"
                                 ( c :: unescape lexbuf )
# 1124 "ocamlbuild/lexers.ml"

  | 2 ->
# 138 "ocamlbuild/lexers.mll"
                                 ( [] )
# 1129 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_unescape_rec lexbuf __ocaml_lex_state

and ocamlfind_query lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 24 (-1) ;   __ocaml_lex_ocamlfind_query_rec lexbuf 130
and __ocaml_lex_ocamlfind_query_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 142 "ocamlbuild/lexers.mll"
                                       n
# 1141 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 143 "ocamlbuild/lexers.mll"
                                           d
# 1146 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(3)
and
# 144 "ocamlbuild/lexers.mll"
                                       v
# 1151 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(4) lexbuf.Lexing.lex_mem.(5)
and
# 145 "ocamlbuild/lexers.mll"
                                          a
# 1156 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(6) lexbuf.Lexing.lex_mem.(7)
and
# 146 "ocamlbuild/lexers.mll"
                                        lo
# 1161 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(8) lexbuf.Lexing.lex_mem.(9)
and
# 147 "ocamlbuild/lexers.mll"
                                        l
# 1166 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(10) lexbuf.Lexing.lex_mem.(11) in
# 148 "ocamlbuild/lexers.mll"
    ( n, d, v, a, lo, l )
# 1170 "ocamlbuild/lexers.ml"

  | 1 ->
# 149 "ocamlbuild/lexers.mll"
      ( raise (Error "Bad ocamlfind query") )
# 1175 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_ocamlfind_query_rec lexbuf __ocaml_lex_state

and trim_blanks lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 6 (-1) ; (* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
  __ocaml_lex_trim_blanks_rec lexbuf 212
and __ocaml_lex_trim_blanks_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 152 "ocamlbuild/lexers.mll"
                          word
# 1190 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 152 "ocamlbuild/lexers.mll"
                                       ( word )
# 1194 "ocamlbuild/lexers.ml"

  | 1 ->
# 153 "ocamlbuild/lexers.mll"
      ( raise (Error "Bad input for trim_blanks") )
# 1199 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_trim_blanks_rec lexbuf __ocaml_lex_state

and tag_gen lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 6 (-1) ;   __ocaml_lex_tag_gen_rec lexbuf 218
and __ocaml_lex_tag_gen_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 156 "ocamlbuild/lexers.mll"
                name
# 1211 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 156 "ocamlbuild/lexers.mll"
                                       param
# 1216 "ocamlbuild/lexers.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(1) in
# 156 "ocamlbuild/lexers.mll"
                                                    ( name, param )
# 1220 "ocamlbuild/lexers.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_tag_gen_rec lexbuf __ocaml_lex_state

;;

